/*------------------------------------------------------------------------------*
 * File Name: DataDisplaySettings.cpp											*
 * Creation: Folger																*
 * Purpose: OriginC Source C++ file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE 						*
 *	Folger 06/17/10 ORG-316-P2 APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME			*
 *	Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS		*
 *	Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT				*
 *	Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING					*
 *	Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE						*
 *	Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS		*
 *	Folger 06/23/10 ORG-316-P5 DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
 *	Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO				*
 *	Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST	*
 *	Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT					*
 *	Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO				*
 *	Folger 07/07/10 ORG-502-S2 SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
 *	Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR	*
 *	Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
 *	Folger 08/10/10 ORG-502-S4 BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS		*
 *	Folger 09/21/2010 ORG-332-P1 DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
 *	Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE				*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#define  BASE_WINDOW		ResizeDialog
#include "DynaDlg.h"

#include "WksColLabels.h"
#include <Array.h>

///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
#include "DataInfoCursor.h"
///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

enum
{
	LISTROW_INFO_FROM			 = 1,
	LISTROW_CONTENT,
	LISTROW_COLUMN_WIDTH,
	LISTROW_FONT_SIZE,

	/// add items before this
	LISTROW_TOTAL,
};

#define		STR_SHORT_NAME			"Short Name"

///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
#define		STR_RAW_DATA			_L("Data(Reader)")
#define		STR_CURSOR1				_L("Data(Cursor1)")
#define		STR_CURSOR2				_L("Data(Cursor2)")
#define		STR_C1DR				_L("Relative(Reader - Cursor1)")
#define		STR_C1C2				_L("Relative(Cursor2 - Cursor1)")

#define		ITEM_SEPARATOR			'|'
///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

#define		STR_INFO_FROM			"Separator|Column Labels|Data Group|Cell in"
#define		STR_INFO_FROM_L			_L(STR_INFO_FROM)

class DataInfoArrangementList : public GridListControl
{
public:
	DataInfoArrangementList()
	{
		///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
		//m_strInfoFrom = "Column Labels|Data Group|Cell in";
		m_strInfoFrom = STR_INFO_FROM;
		///------ End ADD_SEPARATOR_COLUMN_TYPE
	}
	~DataInfoArrangementList()
	{
	}
	
	void Init(int nID, Dialog& dlg)
	{		
		GridListControl::Init(nID, dlg);
		ClearAll();
		
		SetRows(LISTROW_TOTAL, false);
		SetCols(1);
		m_flx.FixedCols = 1;
		m_flx.FixedRows = LISTROW_INFO_FROM;
		
		SetExplorerBar(flexExMove);
		SetSelection(flexSelectionFree);
		SetExtendLastCol(false);
		SetEditable(flexEDKbdMouse);
		
		SetupRowHeading();
		
		InitContents();
	}
	
	/// virtual
	void	ClearAll()
	{
		m_flx.Cols = m_flx.FixedCols;
	}
	
	DataPlot*		DataPlotPtr()
	{
		return &m_dp;
	}
	
	vector<string>&		DefaultColumnValues()
	{
		if ( 0 == m_vsDefaultColumnValues.GetSize() )
		{
			m_vsDefaultColumnValues.Add(GetInfoFromStr(ConvertHeaderIndex(DIS_INFO_FROM_RAW_DATA, FALSE)));
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			//m_vsDefaultColumnValues.Add("");
			m_vsDefaultColumnValues.Add(STR_RAW_DATA);
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			m_vsDefaultColumnValues.Add("10");
			m_vsDefaultColumnValues.Add("1");
		}
		
		return m_vsDefaultColumnValues;
	}
	
	int		GetTotalRowsHeight()
	{
		return YTwipsToPixels(GetRowHeight(0) * (LISTROW_TOTAL + 1.2));
	}
	
	void	AddColumn(vector<string>& vs)
	{
		int		nCol = GetCols();
		AddCol();

		SetColAlignment(nCol, flexAlignCenterCenter);
		SetColWidth(nCol, 1500);
		
		///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
		SetCell(0, nCol, (string)nCol);
		///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING
		SetCells(vs, nCol - GetColOffset());
	}

	///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
	void	ResetColHeading()
	{
		for ( int col=GetColOffset(); col<GetCols(); ++col )
		{
			SetCell(0, col, (string)col);
		}
	}
	///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING

	void	AddDefaultColumn()
	{
		AddColumn(DefaultColumnValues());
	}

	string	GetColName(int nCol)
	{
		string	str;
		str.Format("%s%d", STR_DATA_DISPLAY_SETTINGS_COLUMN_INFO_TAGNAME_PREFIX, nCol);
		return str;
	}
	
	void	OnBeforeEdit(long nRow, long nCol, BOOL* pCancel)
	{
		string	str;
		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			str = GetLocalized(m_strInfoFrom);
			break;

		case LISTROW_CONTENT:
			str = GetContent(nCol);
			break;

		case LISTROW_COLUMN_WIDTH:
			str = "|5|10|15|20|30|40|50";
			break;

		case LISTROW_FONT_SIZE:
			str = "|0.5|1|1.5|2|2.5|3";
			break;
			
		default:
			break;
		}

		if ( str.Find(ITEM_SEPARATOR) >= 0 )
		{
			m_flx.ComboList = str;
		}
		else
		{
			string	strEmpty;
			m_flx.ComboList = strEmpty;
			*pCancel = TRUE;
		}
	}
	
	void	OnAfterEdit(int nRow, int nCol)
	{
	}

	void	OnEdit(int nRow, int nCol)
	{
		if ( LISTROW_INFO_FROM == nRow )
		{
			string		strContent = GetContent(nCol);
			SetCell(LISTROW_CONTENT, nCol, strContent.IsEmpty() ? "" : strContent.GetToken(0, ITEM_SEPARATOR));
		}
	}

	string	GetRowContentForSaving(int nRow, int nCol)
	{
		string		str = GetCell(nRow, nCol);

		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			str.Format("%d", ConvertHeaderIndex(GetInfoFrom(nCol)));
			break;
			
		case LISTROW_CONTENT:
			switch ( ConvertHeaderIndex(GetInfoFrom(nCol)) )
			{
			case DIS_INFO_FROM_DEADER:
				{
					int		nType = -1;
					if ( compare_string_localization(str, STR_SHORT_NAME) )
					{
						nType = RCLT_SHORT_NAME;
					}
					else
					{
						Worksheet		wks;
						GetWorksheet(wks);
						nType = get_label_type_by_name(wks, str);
					}
					str.Format("%d", nType);
				}
				break;

			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			case DIS_INFO_FROM_RAW_DATA:
				str.Format("%d", ConvertDataGroupIndex(GetDataGroup(str)));
				break;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

			///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_SEPARATOR:
			///------ End ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_HIGHLIGHT_CELL:
				UpdateRangeStringForSaving(str);
				break;

			default:
				break;
			}
			break;
			
		case LISTROW_COLUMN_WIDTH:
		case LISTROW_FONT_SIZE:
		default:
			break;
		}
		
		return str;
	}

	string	GetRowContentForLoading(LPCSTR lpcsz, int nRow)
	{
		static	int		l_nLastInfoFrom;
		string			str = lpcsz;

		switch ( nRow )
		{
		case LISTROW_INFO_FROM:
			l_nLastInfoFrom = atoi(lpcsz);
			str = GetInfoFromStr(ConvertHeaderIndex(l_nLastInfoFrom, FALSE));
			break;
			
		case LISTROW_CONTENT:
			switch ( l_nLastInfoFrom )
			{
			case DIS_INFO_FROM_DEADER:
				{
					int		nType = atoi(lpcsz);
					if ( RCLT_SHORT_NAME == nType )
					{
						str = _L(STR_SHORT_NAME);
					}
					else
					{
						Worksheet		wks;
						GetWorksheet(wks);
						str = get_label_name_by_type(nType, wks);
					}
				}
				break;

			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			case DIS_INFO_FROM_RAW_DATA:
				str = GetDataGroupStr(ConvertDataGroupIndex(atoi(lpcsz), FALSE));
				break;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

			///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_SEPARATOR:
			///------ End ADD_SEPARATOR_COLUMN_TYPE
			case DIS_INFO_FROM_HIGHLIGHT_CELL:
				UpdateRangeStringForLoading(str);
				break;

			default:
				break;
			}
			break;
			
		case LISTROW_COLUMN_WIDTH:
		case LISTROW_FONT_SIZE:
		default:
			break;
		}
		
		return str;
	}

	BOOL	GetWorksheet(Worksheet& wks, DataRange* pdr = NULL)
	{
		Datasheet	ds;
		if ( !GetDatasheet(ds, pdr) )
			return FALSE;

		wks = ds;
		return TRUE;
	}

	///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
	BOOL	GetMatrixsheet(MatrixLayer& ml, DataRange* pdr = NULL)
	{
		Datasheet	ds;
		if ( !GetDatasheet(ds, pdr) )
			return FALSE;
		
		ml = ds;
		return TRUE;
	}
	
	BOOL	GetDatasheet(Datasheet& ds, DataRange* pdr = NULL)
	{
		if ( !DataPlotPtr()->IsValid() )
			return FALSE;
		
		DataRange		dr;
		if ( !DataPlotPtr()->GetDataRange(dr) )
			return FALSE;
		
		if ( pdr )
			*pdr = dr;
		
		int				c1, c2;
		return dr.GetRange(ds, c1, c2) && ds;
	}
	///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
	
	void	UpdateRangeStringForSaving(string& str)
	{
		if ( str.IsEmpty() )
			return;
		
		Worksheet		wks;
		if ( GetWorksheet(wks) && wks )
		{
			StringArray		arrObjects;
			str.GetTokens(arrObjects, ITEM_SEPARATOR);
						
			StringArray		arrIndices;
			for ( int ii=0; ii<arrObjects.GetSize(); ++ii )
			{
				string	str = arrObjects[ii];
				int		nCol;
				okutil_check_convert_LT_col(&str, &nCol);
				Column	col = wks.Columns(str);
				if ( col )
					arrIndices.Add((string)col.GetIndex());
			}

			str.SetTokens(arrIndices, ITEM_SEPARATOR);
		}
		else
		{
			str.Empty();
		}
	}
	
	void	UpdateRangeStringForLoading(string& str)
	{
		if ( str.IsEmpty() )
			return;
		
		Worksheet		wks;
		if ( GetWorksheet(wks) && wks )
		{
			StringArray		arrIndices;
			str.GetTokens(arrIndices, ITEM_SEPARATOR);
			
			StringArray		arr;
			for ( int ii=0; ii<arrIndices.GetSize(); ++ii )
			{
				Column		col = wks.Columns(atoi(arrIndices[ii]));
				if ( col )
				{
					string	str;
					col.GetRangeString(str, NTYPE_FOR_RANGE);
					string	strBook, strSheet, strObject;
					okutil_parse_complete_range_string(str, &strBook, &strSheet, &strObject);
					arr.Add(strObject);
				}
			}
			
			okutil_create_complex_generic_range_string(&str, &arr);
		}		
		else
		{
			str.Empty();
		}
	}

	int		ConvertHeaderIndex(int nIndex, BOOL bSaving = TRUE)
	{
		if ( nIndex < 0 )
			return nIndex;

		if ( m_vnHeaderWks.GetSize() == 0 )
		{
			m_vnHeaderWks.Add(DIS_INFO_FROM_SEPARATOR);
			m_vnHeaderMat.Add(DIS_INFO_FROM_SEPARATOR);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_DEADER);
			m_vnHeaderMat.Add(DIS_INFO_FROM_DEADER);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_RAW_DATA);
			m_vnHeaderMat.Add(DIS_INFO_FROM_RAW_DATA);
			
			m_vnHeaderWks.Add(DIS_INFO_FROM_HIGHLIGHT_CELL);
		}
		
		MatrixLayer	ml;
		GetMatrixsheet(ml);
		vector<int>&	vn = ml.IsValid() ? m_vnHeaderMat : m_vnHeaderWks;
		
		return ConvertIndex(vn, nIndex, bSaving, -1);
	}

	int		ConvertDataGroupIndex(int nIndex, BOOL bSaving = TRUE)
	{
		if ( nIndex < 0 )
			return nIndex;

		return ConvertIndex(m_vnDataGroup, nIndex, bSaving, -1);
	}

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	GetColumnHeader(LPSTR szBuffer, int nCol, TreeNode& trSettings)
	{
		TreeNode	trColumns = trSettings.Columns;
		if ( !trColumns )
		{
			O_A_FAIL;
			return FALSE;
		}
		if ( !trColumns.ColHeader.nVal )
			return FALSE;
		
		if ( nCol >= trColumns.NumCols.nVal )
			return FALSE;

		TreeNode	trColumn = trColumns.GetNode(GetColName(nCol + 1));
		if ( !trColumn )
			return FALSE;

		GetRowContentForLoading(trColumn.InfoFrom.strVal, LISTROW_INFO_FROM);
		///------ Folger 07/07/10 ORG-502-S2 SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
		string		str = GetRowContentForLoading(trColumn.Content.strVal, LISTROW_CONTENT);
		int			nIndex = -1;
		if ( (nIndex = str.Find("\"")) > 0 )	/// SN"LN"
		{
			str[str.GetLength()-1] = 0;
			lstrcpy(szBuffer, (LPCSTR)str + nIndex + 1);
		}
		else
		{
			lstrcpy(szBuffer, str);
		}
		///------ End SHOW_LN_ONLY_IN_COLUMN_HEADER_ROW_FOR_HIGHLIGHT_CELLS
		return TRUE;
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL			InitContents()
	{
		Datasheet		ds;
		DataRange		dr;
		if ( !GetDatasheet(ds, &dr) || !ds )
			return FALSE;

		///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
		MatrixLayer		ml(ds);
		if ( ml )
		{
			vector<string>		vs;
			m_strInfoFrom.GetTokens(vs, ITEM_SEPARATOR);
			vs.SetSize(DIS_INFO_FROM_HIGHLIGHT_CELL);		/// remove Highlight Cell
			m_strInfoFrom.SetTokens(vs, ITEM_SEPARATOR);
			
			vs.RemoveAll();
			vs.Add(STR_SHORT_NAME);
			vs.Add(get_label_name_by_type(RCLT_LONG_NAME));
			vs.Add(get_label_name_by_type(RCLT_UNIT));
			vs.Add(get_label_name_by_type(RCLT_COMMENT));
			m_strLabels.SetTokens(vs, ITEM_SEPARATOR);
		}
		else
			///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
		{
			Worksheet	wks(ds);
			if ( !wks )
				return FALSE;
			
			WksCommonColLabelHelper		clHelper;
			clHelper.UpdateCommonColLabelInfo(wks);
			
			vector<string>		vs;
			clHelper.GetLabelNames(vs);
			vs.InsertAt(0, _L(STR_SHORT_NAME));
			m_strLabels.SetTokens(vs, ITEM_SEPARATOR);
			
// 			int		nX = -1, nY = -1, nZ = -1;
// 			for ( int ii=0; ii<dr.GetNumRanges(); ++ii )
// 			{
// 				int			r1, r2, c1, c2;
// 				string		strName;
// 				Datasheet	dsDummy;
// 				if ( dr.GetRange(ii, r1, c1, r2, c2, dsDummy, &strName) )
// 				{
// 					if ( strName.Compare("X") == 0 )
// 						nX = c1;
// 					if ( strName.Compare("Y") == 0 )
// 						nY = c1;
// 					if ( strName.Compare("Z") == 0 )
// 						nZ = c1;
// 				}
// 			}
			
			vs.RemoveAll();
			for ( int ii=0; ii<wks.GetNumCols(); ++ii )
			{
// 				if ( ii == nX || ii == nY || ii == nZ )
// 					continue;
				
				Column	col(wks, ii);
				string	str;
				col.GetRangeString(str, NTYPE_FOR_RANGE);
				string	strBook, strSheet, strObject;
				okutil_parse_complete_range_string(str, &strBook, &strSheet, &strObject);
				vs.Add(strObject);
			}		
			m_strHighlightCell.SetTokens(vs, ITEM_SEPARATOR);
		}
		
		///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
		InitDataGroup();
		///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
		
		return TRUE;
	}
	
private:

	string			GetContent(int nCol)
	{
		string	str;

		int		nInfoFrom = ConvertHeaderIndex(GetInfoFrom(nCol));
		switch ( nInfoFrom )
		{
		case DIS_INFO_FROM_DEADER:
			str = m_strLabels;
			break;
			
		case DIS_INFO_FROM_RAW_DATA:
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			//str.Empty();
			str = m_strDataGroup;
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			break;
			
		case DIS_INFO_FROM_HIGHLIGHT_CELL:
			str = m_strHighlightCell;
			break;
			
		///------ Folger 06/23/10 ORG-372-S2 ADD_SEPARATOR_COLUMN_TYPE
		case DIS_INFO_FROM_SEPARATOR:
		///------ End ADD_SEPARATOR_COLUMN_TYPE
		default:
			break;
		}

		return str;
	}

	void			SetupRowHeading()
	{
		vector<string>	vs;
		string			strRowHeadings = _L("Info From|Content|Column Width|Font Scaler");
		strRowHeadings.GetTokens(vs, ITEM_SEPARATOR);
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			SetCell(ii + 1, 0, vs[ii]);
		}

		ResizeCols();
	}

	int		GetInfoFrom(int nCol)
	{
		return GetInfoFrom(GetCell(LISTROW_INFO_FROM, nCol));
	}

	int		GetInfoFrom(LPCSTR lpcsz)
	{
		if ( 0 == m_vsInfoFrom.GetSize() )
		{
			m_strInfoFrom.GetTokens(m_vsInfoFrom, ITEM_SEPARATOR);
		}
		
		return FindItem(m_vsInfoFrom, lpcsz);
	}

	string	GetInfoFromStr(int nIndex)
	{
		return GetLocalized(m_strInfoFrom.GetToken(nIndex, ITEM_SEPARATOR));
	}

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	int		GetDataGroup(LPCSTR lpcsz)
	{
		return FindItem(m_vsDataGroup, lpcsz);
	}

	string	GetDataGroupStr(int nIndex)
	{
		if ( nIndex < 0 || nIndex >= m_vsDataGroup.GetSize() )
			nIndex = 0;
		return m_vsDataGroup[nIndex];
	}

	int		FindItem(const vector<string>& vs, LPCSTR lpcsz)
	{
		for ( int ii=0; ii<vs.GetSize(); ++ii )
		{
			if ( compare_string_localization(lpcsz, vs[ii]) )
				return ii;
		}
		
		return -1;
	}

	void	InitDataGroup()
	{
		int		nSize = DIC_C1C2 + 1;
		m_vsDataGroup.SetSize(nSize);
		m_vnDataGroup.SetSize(nSize);

		m_vsDataGroup[0] = STR_RAW_DATA;
		m_vnDataGroup[0] = DIC_READER;

		m_vsDataGroup[1] = STR_CURSOR1;
		m_vnDataGroup[1] = DIC_CURSOR1;
		
		m_vsDataGroup[2] = STR_CURSOR2;
		m_vnDataGroup[2] = DIC_CURSOR2;

		m_vsDataGroup[3] = STR_C1DR;
		m_vnDataGroup[3] = DIC_DRC1;

		m_vsDataGroup[4] = STR_C1C2;
		m_vnDataGroup[4] = DIC_C1C2;

		m_strDataGroup.SetTokens(m_vsDataGroup, ITEM_SEPARATOR);
	}

	int		ConvertIndex(const vector<int>& vn, int nIndex, BOOL bSaving, int nValueIfNotFound)
	{
		if ( bSaving )
		{
			ASSERT(nIndex < vn.GetSize());
			return vn[nIndex];
		}
		
		vector<uint>	vnIndices;
		int				nn = vn.Find(vnIndices, nIndex);
		return nn > 0 ? vnIndices[0] : nValueIfNotFound;
	}
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

private:
	DataPlot		m_dp;
	
	string			m_strLabels;
	string			m_strHighlightCell;
	vector<string>	m_vsDefaultColumnValues;

	string			m_strInfoFrom;
	vector<string>	m_vsInfoFrom;
	vector<int>		m_vnHeaderWks;
	vector<int>		m_vnHeaderMat;

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	string			m_strDataGroup;
	vector<string>	m_vsDataGroup;
	vector<int>		m_vnDataGroup;
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
};

static bool	s_bLastUsedUpdatedByDlg = false; //--- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE

enum
{
	DDCM_ID_ADD_COL		= 0,
	DDCM_ID_DELETE_COL,
};

enum
{
	DDCM_CNTRL_NO_DELETE_COL			= 0x00010000,
};

class DataInfoControlMenu : public Menu
{
public:
	DataInfoControlMenu(DWORD dwCntrl = 0)
	{
		m_nChoice = -1;

		Add(_L("&Add Column"), OnMenuItem);
		m_vnIDsMap.Add(DDCM_ID_ADD_COL);

		Add(_L("&Delete Column"), OnMenuItem, O_QUERY_BOOL(dwCntrl, DDCM_CNTRL_NO_DELETE_COL) ? MF_GRAYED : MF_ENABLED);
		m_vnIDsMap.Add(DDCM_ID_DELETE_COL);
	}

	BOOL	GetCommand(int& nChoice)
	{
		if ( m_nChoice >= 0 && m_nChoice < m_vnIDsMap.GetSize() )
		{
			nChoice = m_vnIDsMap[m_nChoice];
			return TRUE;
		}
		return FALSE;
	}

private:
	void	OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

private:
	int				m_nChoice;
	vector<int>		m_vnIDsMap;
};

///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
class	DataRowList : public GridListControl
{
public:
	void	Init(int nID, Dialog& dlg)
	{
		GridListControl::Init(nID, dlg);
		ClearAll();
		
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowSelection = true;

		m_flx.FixedRows = 0;
		SetRows(1, false);
		SetCols(1);
		
	}
	void	SetValues(const vector<string> vs)
	{
		SetColAlignment(0, flexAlignCenterCenter);
		SetRows(vs.GetSize());
		SetColWidth(0, 1500);
		SetCells(vs, 0);
	}
	
	void	GetValues(vector<string>& vs)
	{
		GetColValues(0, vs, GetRowOffset());
	}
	
	int		GetTotalRowsHeight()
	{
		if ( 0 == GetRows() )
			return 0;
		
		return YTwipsToPixels(GetRowHeight(0) * (GetRows() + 1.8));
	}
	
	bool	GetSelectItems(vector<string>& vsItems)
	{
		return GetSelItems(0, vsItems);
	}
	
	bool	AppendItems(vector<string>& vsItems, BOOL bCheckExisting = TRUE)
	{
		vector<string> vs;
		GetValues(vs);
		if ( bCheckExisting )
			remove_if_in_list(vsItems, vs);
		int nRows = GetRows();
		int nNewRows = nRows + vsItems.GetSize();
		if ( nRows == nNewRows )
			return false;
		SetRows(nNewRows, false);
		for ( int iRow = nRows; iRow < nNewRows; iRow++ )
		{
			SetCell(iRow, 0, vsItems[iRow - nRows]);
		}
		return true;
	}
	
	bool	RemoveSelectItems()
	{
		vector<uint> vnRows;
		GetSelRows(vnRows);
		int N = vnRows.GetSize();
		while ( N-- )
		{
			m_flx.RemoveItem(vnRows[N]);
		}
		return true;
	}
};

static	string	_get_column_notation(Column& col)
{
	string str = "";
	if ( col )
	{
		string strLN, strSN;
		strLN = col.GetLongName();
		strSN = col.GetName();
		if ( strLN.IsEmpty() )
			str = strSN;
		else
			str.Format("%s\"%s\"", strSN, strLN);
	}
	return  str;
}
///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

#define		STR_DIALOG_NAME			"DataInfoSettingsDlg"
#define		STR_GRAPH_THEME			"<Graph>"
#define		STR_LAYER_THEME			"<Layer>"
#define		STR_PLOT_THEME			"<DataPlot>"

class DataInfoThemeMenu : public ThemeControlMenu
{
public:
	DataInfoThemeMenu(BOOL bSave, BOOL bDelete, BOOL bLoad, vector<string>& vsThemes, int nSel)
	{
		m_nChoice = -1;

		string		str;
		LPCSTR		lpcszSaveTo = _L("Save to");
		
		str.Format("%s %s", lpcszSaveTo, STR_GRAPH_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_GRAPH);

		str.Format("%s %s", lpcszSaveTo, STR_LAYER_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_LAYER);

		str.Format("%s %s", lpcszSaveTo, STR_PLOT_THEME);
		Add(str, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_TO_PLOT);

		///------ Folger 06/21/10 ORG-316-P4 SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS
		Add(STR_SAVE_AS_DEFAULT, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS_DEFAULT);
		///------ End SUPPORT_DEFAULT_THEME_IN_DATA_INFO_SETTINGS

		Add(_L("Save"), OnMenuItem, bSave ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_SAVE);
		
		Add(_L("Save As") + STR_THREE_DOTS, OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_SAVE_AS);

		THEME_MENU_ADD_SEPARATOR;

		Add(_L("System Default"), OnMenuItem);
		m_vnIndecesMap.Add(THEME_MENU_RESET);
		
        Add(_L("Delete") + STR_THREE_DOTS, OnMenuItem, bDelete ? MF_ENABLED : MF_GRAYED);
		m_vnIndecesMap.Add(THEME_MENU_DELETE);

		m_nCount = m_vnIndecesMap.GetSize();

		AddThemeItems(bLoad, nSel);
	}
};

///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
class SrcDataMenu : public Menu
{
public:
	SrcDataMenu()
	{
		m_nChoice = -1;

		string		str;
		LPCSTR		lpcszFormat = "%s : %s";

		str.Format(lpcszFormat, STR_SRC_INDEX, STR_ROW_INDEX);
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_X, _L("X Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_Y, _L("Y Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_DISP_Z, _L("Z Coordinate"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_X, _L("Source X Data"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_Y, _L("Source Y Data"));
		Add(str, OnMenuItem);

		str.Format(lpcszFormat, STR_SRC_Z, _L("Source Z Data"));
		Add(str, OnMenuItem);

		///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
		Add(NULL, OnMenuItem, MF_SEPARATOR);

		str.Format(lpcszFormat, STR_DISP_SEP, _L("Separator"));
		Add(str, OnMenuItem);
		///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
	}

	void	OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}

	BOOL	GetCommand(int& nChoice)
	{
		nChoice = m_nChoice;
		return nChoice >= 0;
	}
	
protected:
	int	m_nChoice;
};
///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

enum
{
	DISTAB_TITLE			= 0,
	DISTAB_ROWS,
	DISTAB_COLS,
	DISTAB_DISPLAY,
};

class	DataInfoSettingsDlg : public DynaDlg
{
public:
	DataInfoSettingsDlg(TreeNode& trSettings, DataPlot& dp) : DynaDlg(IDD_DATA_INFO_SETTINGS, NULL, "ODlg8")
	{
		m_trSettings = trSettings;
		if ( m_trSettings )
			m_trSettings.GetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		*m_DataInfoList.DataPlotPtr() = dp;
	}
	~DataInfoSettingsDlg()
	{
	}

	int		DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hWndParent);
		return nRet;
	}

	BOOL	GetDefaultSettings(TreeNode& tr, BOOL bFactory = FALSE)
	{
		static	Tree	l_trDefault;
		if ( l_trDefault.IsEmpty() )
		{
			l_trDefault.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_DATA_INFO_CLASS_SETTINGS);

			/// Title
			TreeNode	trTitle = l_trDefault.AddNode("Title");
			trTitle.Replace(GetTitle(TRUE), TRUE, TRUE);
			
			/// Columns
			vector<string>			vs1, vs2;
			vs2 = vs1 = m_DataInfoList.DefaultColumnValues();
			
			vs1[LISTROW_INFO_FROM-1].Format("%d", DIS_INFO_FROM_DEADER);
			vs1[LISTROW_CONTENT-1].Format("%d", RCLT_SHORT_NAME);
			
			vs2[LISTROW_INFO_FROM-1].Format("%d", DIS_INFO_FROM_RAW_DATA);
			///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			vs2[LISTROW_CONTENT-1].Format("%d", DIC_READER);
			///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
			
			Array<vector<string>&>	arrCols;
			arrCols.Add(vs1);
			arrCols.Add(vs2);
			TreeNode	trColumns = l_trDefault.AddNode("Columns");
			SaveColumnsSettings(trColumns, arrCols, 1);
			
			/// Display
			TreeNode	trDisplay = l_trDefault.AddNode("Display");
			trDisplay.Replace(GetDisplay(TRUE), TRUE, TRUE);
		}
		
		/// Rows
		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		TreeNode	trRows = tree_check_get_node(l_trDefault, "Rows");
		vector<int>	vnIndices, vnDefault;
		///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		InitColsList(vnIndices, vnDefault);
		///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
		TreeNode trLeftGrid = tree_check_get_node(trRows, "LeftGrid");
		trLeftGrid.DataID = ID_DATAINFOSETTINGS_AVAILABLE;
		trLeftGrid.nVals = vnIndices;
		TreeNode trRightGrid = tree_check_get_node(trRows, "RightGrid");
		trRightGrid.DataID = ID_DATAINFOSETTINGS_SELECTED;
		trRightGrid.nVals = vnDefault;
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

		tr.Replace(l_trDefault, TRUE, TRUE);
		if ( !bFactory )
		{
			GraphPage	gp;
			GraphLayer	gl;
			DataPlot	dp;
			GetRelatedObj(&gp, &gl, &dp);
			vector<string>		vsThemes = { STR_PLOT_THEME
				, STR_LAYER_THEME
				, STR_GRAPH_THEME
				, THEME_FILENAME_LAST_USED
			};
			//---- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE
			if(!s_bLastUsedUpdatedByDlg)
			{
				vsThemes.SetSize(vsThemes.GetSize()-1); // del <last used>
			}
			//----
			///------ Folger 06/23/10 ORG-316-P5 DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
			vsThemes.Add(STR_DEFAULT_E);
			///------ End DEFAULT_THEME_FAILED_TO_LOAD_WHEN_OPEN_DATA_INFO_SETTINGS
			
			for ( int ii=0; ii<vsThemes.GetSize(); ++ii )
			{
				if ( LoadTheme(tr, vsThemes[ii]) )
					break;
			}
		}

		return TRUE;
	}

	int		ConvertHeaderIndex(int nIndex, BOOL bSaving = TRUE)
	{
		return m_DataInfoList.ConvertHeaderIndex(nIndex, bSaving);
	}

	int		ConvertDataGroupIndex(int nIndex, BOOL bSaving = TRUE)
	{
		return m_DataInfoList.ConvertDataGroupIndex(nIndex, bSaving);
	}

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	BOOL	GetCursorValue(CursorValue* pCursor)
	{
		DataInfoCursor&		cursor = DataCursor(pCursor->nCursorType);
		if ( !cursor.IsValid() )
			return FALSE;

		double	x = NANUM, y = NANUM, z = NANUM;
		cursor.GetLastXYZ(x, y, z);

		switch ( pCursor->nValueType )
		{
		case DISSRC_X:
			pCursor->rValue = x;
			break;

		case DISSRC_Y:
			pCursor->rValue = y;
			break;

		case DISSRC_Z:
			pCursor->rValue = z;
			break;

		default:
			return FALSE;
		}

		return TRUE;
	}
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	GetColumnHeader(LPSTR szBuffer, int nCol)
	{
		m_DataInfoList.InitContents();
		return m_DataInfoList.GetColumnHeader(szBuffer, nCol, m_trSettings);
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	
protected:
	///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
	BOOL	OnSrcPopup(Control ctrl)
	{
		SrcDataMenu		myMenu;

		RECT 				rr;
		ctrl.GetClientRect(&rr);
		ctrl.ClientToScreen(&rr);
		myMenu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		int					nCmd;
		if( myMenu.GetCommand(nCmd) )
		{
			vector<int>	vnMap = { DISSRC_ROW_NUM
				, DISSRC_X
				, DISSRC_Y
				, DISSRC_Z
				, DISSRC_XINDEX
				, DISSRC_YINDEX
				, DISSRC_ZINDEX
				, 0		/// separator
				///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
				, DISSRC_SEP
				///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
			};

			vector<string>		vs(1);
			IndexToName(vs[0], vnMap[nCmd]);
			m_DataSelected.AppendItems(vs, DISSRC_SEP != vnMap[nCmd]);
			enableApply();
		}
		return TRUE;
	}
	///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

	bool	OnThemePopup(Control ctrl)
	{
		Tree	tr;
		SaveSettings(tr);
		
		vector<string>		vsThemes;
		vector<string>		vsThemesExcludeLastUsed;
		int					nDefaultOffset = 0;
		int					nSel = PrepareThemes(nDefaultOffset, vsThemes, vsThemesExcludeLastUsed, tr);
		
		DataInfoThemeMenu	menu(TRUE, vsThemesExcludeLastUsed.GetSize(), TRUE, vsThemes, nSel);
		
		RECT 				rr;
		ctrl.GetClientRect(&rr);
		ctrl.ClientToScreen(&rr);
		menu.TrackPopupMenu(0,  rr.right, rr.top, GetSafeHwnd());
		
		int					nCmd;
		if( menu.GetCommand(nCmd) )
		{
			HandleThemeCmd(nCmd, tr, vsThemes, nDefaultOffset);
		}
		
		return true;
	}

	virtual	void	HandleThemeCmd(int nCmd, TreeNode& tr, vector<string>& vsThemes, int nDefaultOffset = 0)
	{
		switch ( nCmd )
		{
		case THEME_MENU_SAVE_TO_GRAPH:
		case THEME_MENU_SAVE_TO_LAYER:
		case THEME_MENU_SAVE_TO_PLOT:
			{
				GraphPage	gp;
				GraphLayer	gl;
				DataPlot	dp;
				GetRelatedObj(&gp, &gl, &dp);

				OriginObject	obj;
				switch ( nCmd )
				{
				case THEME_MENU_SAVE_TO_GRAPH:
					m_strThemeFile = STR_GRAPH_THEME;
					obj = gp;
					break;
				case THEME_MENU_SAVE_TO_LAYER:
					m_strThemeFile = STR_LAYER_THEME;
					obj = gl;
					break;
				case THEME_MENU_SAVE_TO_PLOT:
					m_strThemeFile = STR_PLOT_THEME;
					obj = dp;
					break;
				}

				if ( obj )
				{
					tr.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
					SaveThemeIntoObj(tr, obj);
					LoadThemeFilesToCombo(tr);
				}
			}
			break;

		case THEME_MENU_RESET:
			m_strThemeFile.Empty();
			GetDefaultSettings(tr, TRUE);
			goto _default;
			
		case THEME_MENU_SAVE:
			int		nMenuID = -1;
			if ( m_strThemeFile.Compare(STR_GRAPH_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_GRAPH;
			else if ( m_strThemeFile.Compare(STR_LAYER_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_LAYER;
			else if ( m_strThemeFile.Compare(STR_PLOT_THEME) == 0 )
				nMenuID = THEME_MENU_SAVE_TO_PLOT;

			if ( nMenuID >= 0 )
			{
				HandleThemeCmd(nMenuID, tr, vsThemes, nDefaultOffset);
				break;
			}
			goto _default;

		_default:
		default:
			DynaDlg::HandleThemeCmd(nCmd, tr, vsThemes, nDefaultOffset);
		}

		if ( THEME_MENU_SAVE_AS == nCmd || nCmd >= THEME_MENU_LOADING_START )
		{
			tr.GetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		}

		if ( THEME_MENU_RESET == nCmd || nCmd >= THEME_MENU_LOADING_START )
		{
			LoadSettings(tr);
			DisplayTab(m_nCurrTab);
			///------ Folger 06/17/10 ORG-316-P2 APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME
			enableApply();
			///------ End APPLY_FAILED_TO_ENABLE_AFTER_LOAD_THEME
		}
	}
	
	virtual BOOL LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName)
	{
		OriginObject	obj;
		obj = GetRelatedObj(NULL, NULL, NULL, lpcszThemeName);
		if ( obj )
		{
			Tree			trTheme;
			if ( !tree_get_binary_storage(trTheme, obj, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
				return FALSE;
			
			vector<int>		vnIDs;
			vector<string>	vsValues;
			string			strDes;
			if ( octree_get_theme(&trTheme, &vnIDs, &vsValues, &strDes) )
			{
				int nDupID = 0;
				int nn = tree_set_values_by_ids(trGetN, vnIDs, vsValues, 0, &nDupID, 0);
				if ( nDupID )
				{
					O_A_FAIL;
					return FALSE;
				}
			}
			trGetN.SetAttribute(STR_THEME_FILE_ATTRIB, lpcszThemeName);
			return TRUE;
		}

		return DynaDlg::LoadTheme(trGetN, lpcszThemeName);
	}

	virtual	void	DeleteOneTheme(LPCSTR lpcszTheme, LPCSTR lpcszClassOption, LPCSTR lpcszPath)
	{
		OriginObject	obj;
		obj = GetRelatedObj(NULL, NULL, NULL, lpcszTheme);
		if ( obj )
		{
			obj.SetMemory(STR_DATA_INFO_SETTINGS_STORAGE_NAME, NULL);
			return;
		}

		DynaDlg::DeleteOneTheme(lpcszTheme, lpcszClassOption, lpcszPath);
	}

	OriginObject	GetRelatedObj(GraphPage* pgp, GraphLayer* pgl, DataPlot* pdp, LPCSTR lpcszTheme = NULL)
	{
		DataPlot	dp = *m_DataInfoList.DataPlotPtr();
		GraphLayer	gl;
		GraphPage	gp;
		if ( dp )
			dp.GetParent(gl);
		if ( gl )
			gl.GetParent(gp);

		if ( pgp )
			*pgp = gp;
		if ( pgl )
			*pgl = gl;
		if ( pdp )
			*pdp = dp;

		if ( lpcszTheme )
		{
			if ( lstrcmp(lpcszTheme, STR_GRAPH_THEME) == 0 )
				return gp;
			if ( lstrcmp(lpcszTheme, STR_LAYER_THEME) == 0 )
				return gl;
			if ( lstrcmp(lpcszTheme, STR_PLOT_THEME) == 0 )
				return dp;
		}

		OriginObject	objJunk;
		return objJunk;
	}

private:
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_DESTROY(OnDestroy)
		ON_OK(OnOK)
		ON_BN_CLICKED(IDC_APPLY, OnApply)
		ON_BN_CLICKED(IDC_THEME_POPUP, OnThemePopup)
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		ON_BN_CLICKED(IDC_BTN_SRC_POPUP, OnSrcPopup)
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		ON_BN_CLICKED(IDC_ADD_COLUMN_HEADING, OnCheckColHeader)
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		ON_BN_CLICKED(IDC_BTN_SELECT, OnSelect)
		ON_BN_CLICKED(IDC_BTN_REMOVE, OnRemove)
		ON_BN_CLICKED(IDC_BTN_UP, OnMoveUp)
		ON_BN_CLICKED(IDC_BTN_DOWN, OnMoveDown)
		ON_GRID_SEL_CHANGE(IDC_DATA_AVAILABLE, OnSelRowChange)
		ON_GRID_SEL_CHANGE(IDC_DATA_SELECTED, OnSelRowChange)
		ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
		ON_GRID_MOUSE_MOVE(IDC_DATA_AVAILABLE, OnMouseMoveOnDataList)
		ON_GRID_MOUSE_MOVE(IDC_DATA_SELECTED, OnMouseMoveOnDataList)
		///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
		ON_GETNDLG_MSGS(IDC_DISPLAY_SETTINGS)

		ON_GRID_BEFORE_EDIT(IDC_DATA_INFO_ARRAGEMENT, OnBeforeEditDataInfo)
		ON_GRID_AFTER_EDIT(IDC_DATA_INFO_ARRAGEMENT, OnAfterEditDataInfo)
		ON_GRID_CELL_CHANGE(IDC_DATA_INFO_ARRAGEMENT, OnEditDataInfo)
		ON_GRID_AFTER_MOVE_COLUMNS(IDC_DATA_INFO_ARRAGEMENT, OnAfterMoveColumns)

		ON_TAB_SEL_CHANGE(IDC_DATA_INFO_TAB, OnTabChange)
		
		ON_CONTEXTMENU(OnShowMenu)
EVENTS_END

	BOOL	OnInitDialog()
	{
		BOOL	bRet = ResizeDialog::OnInitDialog();

		m_DataInfoList.Init(IDC_DATA_INFO_ARRAGEMENT, *this);		

		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		m_DataAvailable.Init(IDC_DATA_AVAILABLE, *this);
		m_DataSelected.Init(IDC_DATA_SELECTED, *this);
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

		///Sophy 6/11/2010 ORG-120-S21 BITMAP_FOR_UP_DOWN_BUTTONS_ON_ROWS_TAB
		vector<string> vsTips;
		BitmapRadioButton btnUp = GetItem(IDC_BTN_UP);
		btnUp.Init(1, IDB_ARROW_UP, 16, vsTips);
		BitmapRadioButton btnDown = GetItem(IDC_BTN_DOWN);
		btnDown.Init(1, IDB_ARROW_DOWN, 16, vsTips);
		///end BITMAP_FOR_UP_DOWN_BUTTONS_ON_ROWS_TAB

		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader = GetItem(IDC_ADD_COLUMN_HEADING);
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

		LoadSettings(m_trSettings);
		InitDynaControl(IDC_DISPLAY_SETTINGS);

		Tree	trJunk;
		SaveSettings(trJunk);
		InitThemeControls(this, trJunk, IDC_PARAMS_THEME, IDC_PARAMS_THEME_LABEL, IDC_JUNK, IDC_THEME_POPUP, 0, 0);
		BitmapRadioButton	m_btnThemePopup = GetItem(IDC_THEME_POPUP);
		m_btnThemePopup.Init(1, IDB_DROP_DOWN_UP, 16, vsTips);
		
		m_tab = GetItem(IDC_DATA_INFO_TAB);
		m_tab.InsertItem(DISTAB_TITLE, _L("Title"));
		m_tab.InsertItem(DISTAB_ROWS, _L("Data Group Rows"));
		m_tab.InsertItem(DISTAB_COLS, _L("Report Columns"));
		m_tab.InsertItem(DISTAB_DISPLAY, _L("Display"));
		CurrTabInReg(m_nCurrTab, TRUE);
		m_tab.SetCurSel(m_nCurrTab);
		DisplayTab(m_nCurrTab);

		enableApply(false);
		SetInitReady(true);	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		return bRet;
	}
	
	BOOL	OnDestroy()
	{
		CurrTabInReg(m_nCurrTab, FALSE);
		return ResizeDialog::OnDestroy();
	}
	
	BOOL	UpdateTreeFromDyna()
	{		
		switch ( m_nCurrTab )
		{
		case DISTAB_TITLE:
			m_trTitle.Replace(GetTree(), TRUE, TRUE);
			break;
			
		case DISTAB_ROWS:
			break;
			
		case DISTAB_COLS:
			break;
			
		case DISTAB_DISPLAY:
			m_trDisplay.Replace(GetTree(), TRUE, TRUE);
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		return TRUE;
	}

	BOOL	OnTabChange(Control ctrl)
	{
		UpdateTreeFromDyna();
		return DisplayTab(m_nCurrTab = m_tab.GetCurSel());
	}
	
	BOOL	OnOK()
	{
		SaveOnApply();
		return TRUE;
	}

	BOOL	OnApply(Control ctrl)
	{
		SaveOnApply();
		UpdateDataInfoWindow();
		enableApply(false);
		return TRUE;
	}

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	BOOL	OnCheckColHeader(Control ctrl)
	{
		enableApply();
		return TRUE;
	}
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO

	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	BOOL	OnSelect(Control ctrl)
	{
		vector<string> vsLeft;
		m_DataAvailable.GetSelectItems(vsLeft);
		m_DataSelected.AppendItems(vsLeft);
		updateButtonsOnselection();
		enableApply();
		return TRUE;
	}
	
	BOOL	OnRemove(Control ctrl)
	{
		vector<string> vsRight;
		m_DataSelected.GetSelectItems(vsRight);
		m_DataSelected.RemoveSelectItems();
		updateButtonsOnselection();
		enableApply();
		return TRUE;
	}
	
	BOOL	OnMoveUp(Control ctrl)
	{
		vector<uint> vnRows;
		m_DataSelected.GetSelRows(vnRows);
		ASSERT(vnRows.GetSize() == 1);
		
		enableApply();
		return m_DataSelected.MoveItemUp(vnRows[0]);
	}
	
	BOOL	OnMoveDown(Control ctrl)
	{
		vector<uint> vnRows;
		m_DataSelected.GetSelRows(vnRows);
		ASSERT(vnRows.GetSize() == 1);
		
		enableApply();
		return m_DataSelected.MoveItemDown(vnRows[0]);
	}
	
	BOOL	OnSelRowChange(Control ctrl)
	{
		if ( IsInitReady() )
		{
			updateButtonsOnselection();
			return TRUE;
		}
		return FALSE;
	}

	///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
	void	OnMouseMoveOnDataList(Control cntrl, short nButton, short nShift, float X, float Y)
	{
 		DataRowList*		pList = &m_DataSelected;
 		if ( cntrl.GetSafeHwnd() == m_DataAvailable.GetCtrnlSafeHwnd() )
 			pList = &m_DataAvailable;

		int	nRow, nCol;
		if ( !pList->GetMouseCell(nRow, nCol) || nRow < 0 || nCol < 0 )
			return;

		string	str = pList->GetCell(nRow, nCol);
		pList->SetToolTipsText(str);
	}
	///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
	
	void	OnAfterValueChange(int nRow, int nCol)
	{
		enableApply();
	}
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	OnBeforeEditDataInfo(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		m_DataInfoList.OnBeforeEdit(nRow, nCol, pCancel);
	}
	
	void	OnAfterEditDataInfo(Control flxControl, int nRow, int nCol)
	{
		m_DataInfoList.OnAfterEdit(nRow, nCol);
		enableApply();
	}
	
	void	OnEditDataInfo(Control flxControl, int nRow, int nCol)
	{
		m_DataInfoList.OnEdit(nRow, nCol);
	}

	void	OnAfterMoveColumns(Control flxControl, long lCol, long *pnPosition)
	{
		enableApply();
		///------ Folger 06/23/10 ORG-372-S4 ADD_COLUMN_INDEX_TO_GRID_HEADING
		m_DataInfoList.ResetColHeading();
		///------ End ADD_COLUMN_INDEX_TO_GRID_HEADING
	}

	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if ( DISTAB_COLS != m_nCurrTab )
			return FALSE;
		
		///------ Folger 08/06/10 ORG-502-P5 CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
		RECT	rr;
		m_DataInfoList.GetWindowRect(rr);
		POINT	pt;
		pt.x = nx, pt.y = ny;
		if ( !pt_in_rect(rr, pt) )
			return FALSE;
		///------ End CONTEXT_MENU_OF_ADD_DELETE_COL_SHOULD_ONLY_SHOW_IN_GRID_TABLE
		
		int		nRow = -1, nCol = -1;
		m_DataInfoList.GetMouseCell(nRow, nCol);
		
		DWORD	dwCntrl = 0;
		if ( nCol < m_DataInfoList.GetColOffset() )
			O_ADD_BIT(dwCntrl, DDCM_CNTRL_NO_DELETE_COL);
		DataInfoControlMenu		menu(dwCntrl);
		menu.TrackPopupMenu(0,  nx, ny, GetSafeHwnd());
		
		int		nCmd;
		if( menu.GetCommand(nCmd) )
		{
			BOOL	bEnabled = TRUE;
			switch ( nCmd )
			{
			case DDCM_ID_ADD_COL:
				m_DataInfoList.AddDefaultColumn();
				break;
				
			case DDCM_ID_DELETE_COL:
				m_DataInfoList.DeleteCol(nCol);
				m_DataInfoList.ResetColHeading();
				break;
				
			default:
				bEnabled = FALSE;
				break;
			}
			if ( bEnabled )
				enableApply(TRUE);
		}
		
		return TRUE;
	}

	BOOL	DisplayTab(int nTab)
	{
		Control		DataInfoGrid = GetItem(IDC_DATA_INFO_ARRAGEMENT);
		Control		DataInfoDyna = GetItem(IDC_DISPLAY_SETTINGS);
		Control		HintModifyColumn = GetItem(IDC_HINT_MODIFY_COLUMN);
		///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		Control		DataAvailable = GetItem(IDC_DATA_AVAILABLE);
		Control		DataSelected = GetItem(IDC_DATA_SELECTED);
		Control		BtnUp = GetItem(IDC_BTN_UP);
		Control		BtnDown = GetItem(IDC_BTN_DOWN);
		Control		BtnSelect = GetItem(IDC_BTN_SELECT);
		Control		BtnRemove = GetItem(IDC_BTN_REMOVE);
		Control		TextRange = GetItem(IDC_BOOKSHEET_COLUMN);
		Control		TextShowData = GetItem(IDC_DATA_TO_SHOW);
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		Control		BtnSrcPopup = GetItem(IDC_BTN_SRC_POPUP);
		BtnSrcPopup.Visible =
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader.Visible =
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		DataAvailable.Visible =
		DataSelected.Visible =
		BtnUp.Visible =
		BtnDown.Visible =
		BtnSelect.Visible =
		BtnRemove.Visible =
		TextRange.Visible =
		TextShowData.Visible =
		///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
		DataInfoGrid.Visible =
		DataInfoDyna.Visible = 
		HintModifyColumn.Visible = FALSE;

		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			DataInfoDyna.Visible = TRUE;
			SetInputTree(DISTAB_TITLE == nTab ? GetTitle(FALSE) : GetDisplay(FALSE));
			UpdateDynaControl(true, GETNEVENT_ON_INIT, true, 0, true);
			break;

		case DISTAB_ROWS:
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			string strRng = "";
			if ( m_DataInfoList.DataPlotPtr()->IsValid() )
				m_DataInfoList.DataPlotPtr()->GetRangeString(strRng, NTYPE_BOOKSHEET_XY_RANGE);
			TextRange.Text = strRng;
			DataAvailable.Visible =
			DataSelected.Visible =
			BtnUp.Visible =
			BtnDown.Visible =
			BtnSelect.Visible =
			BtnRemove.Visible =
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			BtnSrcPopup.Visible =
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			TextRange.Visible =
			TextShowData.Visible = TRUE;
			updateButtonsOnselection();
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			break;

		case DISTAB_COLS:
			HintModifyColumn.Visible = 
			DataInfoGrid.Visible = 
			///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
			m_chkColHeader.Visible = TRUE;
			///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
			break;

		default:
			O_A_FAIL;
			return FALSE;
		}

		Resize(nTab);
		return TRUE;
	}

	/// virtual
	void	resizeDlgToFit(int cx = 0, int cy = 0)
	{
		Resize(m_tab.GetCurSel());
	}

	BOOL	Resize(int nTab)
	{
		int		nGap = GetControlGap();
		SIZE	sz;
		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			TREE_CTRL_VAR.GetOptimalSize(sz);
			break;
			
		case DISTAB_ROWS:
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			{
				RECT	rr;
				GetClientRect(GetItem(IDC_BOOKSHEET_COLUMN), rr);
				int		nHeightLeft = m_DataAvailable.GetTotalRowsHeight();
				int		nHeightRight = m_DataSelected.GetTotalRowsHeight();
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				//RECT	rbtn;
				//GetClientRect(GetItem(IDC_BTN_SELECT), rbtn);
				//int		nMinHeight = RECT_HEIGHT(rbtn) * 2 + 4 * nGap;
				int		nMinHeight = GetRowTabHeight(TRUE);
				int		nMaxHeight = GetRowTabHeight(FALSE);
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				nMinHeight = max(nMinHeight, nHeightLeft);
				nMinHeight = max(nMinHeight, nHeightRight);
				nMinHeight = min(nMinHeight, nMaxHeight);
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				sz.cy = nMinHeight + RECT_HEIGHT(rr) + 2 * nGap;
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			}
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			break;
			
		case DISTAB_COLS:
			{
				RECT	rr1;
				GetClientRect(GetItem(IDC_HINT_MODIFY_COLUMN), rr1);
				///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				RECT	rr2;
				GetClientRect(m_chkColHeader, rr2);
				///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				sz.cy = m_DataInfoList.GetTotalRowsHeight() + RECT_HEIGHT(rr1) + RECT_HEIGHT(rr2) + 3 * nGap;
			}
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}

		MoveControlsHelper	_temp(this);

		Button	btnOK;
		RECT	rrOK;
		GetControlClientRect(IDOK, rrOK, &btnOK);

		ComboBox	combo;
		RECT		rrCombo;
		GetControlClientRect(IDC_PARAMS_THEME, rrCombo, &combo);

		int		nTotalHeight = RECT_HEIGHT(rrCombo) + sz.cy + RECT_HEIGHT(rrOK) + 12 * nGap;
		
		uint	btnIDs[] = { IDCANCEL
			, IDOK
			, IDC_APPLY
			, 0
		};
		
		int		nTotalWidth = 0;
		for ( int ii=0; btnIDs[ii]; ++ii )
		{
			RECT	rr;
			GetClientRect(GetItem(btnIDs[ii]), rr);
			nTotalWidth += RECT_WIDTH(rr) + nGap;
		}
		nTotalWidth = nTotalWidth * 4.7 + 3 * nGap;

		/// Resize Theme Controls
		Button	btnPopup;
		RECT	rrPopup;
		GetControlClientRect(IDC_THEME_POPUP, rrPopup, &btnPopup);
		
		Control	themeLabel;
		RECT	rrThemeLabel;
		GetControlClientRect(IDC_PARAMS_THEME_LABEL, rrThemeLabel, &themeLabel);
		///------ Folger 10/25/2010 ORG-1279 DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE
		CheckResizeThemeLabel(IDC_PARAMS_THEME_LABEL);
		///------ End DIALOG_DISPLAY_NOT_GOOD_IN_CHINESE

		rrCombo.right = rrCombo.left + nTotalWidth - RECT_WIDTH(rrThemeLabel) - RECT_WIDTH(rrPopup) - 7 * nGap;
		MoveControl(combo, rrCombo);

		MoveControl(IDC_THEME_POPUP, rrCombo.right + nGap, rrPopup.top);
		
		RECT	rrWin, rrClient;
		m_wndDlg.GetWindowRect(&rrWin);
		m_wndDlg.GetClientRect(&rrClient);
		int		nNonClientHeight = RECT_HEIGHT(rrWin) - RECT_HEIGHT(rrClient);
		rrWin.right = rrWin.left + nTotalWidth;
		rrWin.bottom = rrWin.top+ nTotalHeight + nNonClientHeight;
		MoveWindow(&rrWin, TRUE);		
		
		ArrangeMainItemAndControls(btnIDs, IDC_DATA_INFO_TAB, NULL, false);
		RECT	rrTab;
		GetClientRect(m_tab, rrTab);
		m_tab.AdjustRect(FALSE, &rrTab);
		///------ Folger 08/10/10 ORG-502-S4 BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS
		RECT	rrPanel;
		rrPanel = rrTab;
		rrPanel.left -= nGap / 2;
		MoveControl(GetItem(IDC_DISPLAY_INFO_BK_PANEL), rrPanel);
		///------ End BETTER_BK_COLOR_BETWEEN_DIALOG_AND_CONTROLS
		
		switch ( nTab )
		{
		case DISTAB_TITLE:
		case DISTAB_DISPLAY:
			MoveControl(GetItem(IDC_DISPLAY_SETTINGS), rrTab);
			break;
			
		case DISTAB_ROWS:
			///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			{
				RECT rr;			
				RECT rr2;
				RECT rr3;
				RECT rr4;
								
				//select, remove buttons
				Control ctrlBtn = GetItem(IDC_BTN_SELECT);
				GetClientRect(ctrlBtn, rr);
				rr2.left = rrTab.left + (RECT_WIDTH(rrTab) - RECT_WIDTH(rr)) / 2;
				rr2.top = rrTab.top + RECT_HEIGHT(rrTab) / 4 + 2 * nGap;
				rr2.right = rr2.left + RECT_WIDTH(rr);
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr2);
				
				ctrlBtn = GetItem(IDC_BTN_REMOVE);
				GetClientRect(ctrlBtn, rr);
				rr3.left = rr2.left;
				rr3.top = rr2.bottom + 2 * nGap;
				rr3.right = rr2.right;
				rr3.bottom = rr3.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr3);

				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				GetControlClientRect(IDC_BTN_SRC_POPUP, rr, &ctrlBtn);
				rr4.left = rr3.left;
				rr4.top = rr3.bottom + 2 * nGap;
				rr4.right = rr3.right;
				rr4.bottom = rr4.top + RECT_HEIGHT(rr);
				MoveControl(ctrlBtn, rr4);
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

				//book sheet column hint
				Control ctrlHint = GetItem(IDC_BOOKSHEET_COLUMN);
				GetClientRect(ctrlHint, rr);
				rr2.left = rrTab.left + nGap;
				rr2.top = rrTab.top + 2 * nGap;
				rr2.right = rr3.left - 2 * nGap;
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlHint, rr2);
				
				//up, down buttons
				ctrlBtn = GetItem(IDC_BTN_DOWN);
				GetClientRect(ctrlBtn, rr);
				rr2.top = rrTab.top + nGap;
				rr2.right = rrTab.right - 2 * nGap;
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				rr2.left = rr2.right - RECT_WIDTH(rr);
				MoveControl(ctrlBtn, rr2);
				
				ctrlBtn = GetItem(IDC_BTN_UP);
				GetClientRect(ctrlBtn, rr);
				rr4.top = rrTab.top + nGap;
				rr4.bottom = rr4.top + RECT_HEIGHT(rr);
				rr4.right = rr2.left - nGap;
				rr4.left = rr4.right - RECT_WIDTH(rr);
				MoveControl(ctrlBtn, rr4);
				
				//data to show hint
				ctrlHint = GetItem(IDC_DATA_TO_SHOW);
				GetClientRect(ctrlHint, rr);
				rr2.left = rr3.right + 2 * nGap;
				rr2.top = rrTab.top + 2 * nGap;
				rr2.right = rr4.left - nGap;  
				rr2.bottom = rr2.top + RECT_HEIGHT(rr);
				MoveControl(ctrlHint, rr2);
				
				//grid list controls
				Control ctrlGrid = GetItem(IDC_DATA_AVAILABLE);
				GetClientRect(ctrlGrid, rr);
				rr2.left = rrTab.left + nGap;
				rr2.right = rr3.left - 2 * nGap;
				rr2.top = rr4.bottom + 2 * nGap;
				rr2.bottom = rrTab.bottom - nGap;
				MoveControl(ctrlGrid, rr2);
				
				ctrlGrid = GetItem(IDC_DATA_SELECTED);
				GetClientRect(ctrlGrid, rr);
				rr2.left = rr3.right + 2 * nGap;
				rr2.right = rrTab.right - nGap;
				rr2.top = rr4.bottom + 2 * nGap;
				rr2.bottom = rrTab.bottom - nGap;
				MoveControl(ctrlGrid, rr2);
			}
			///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
			break;
			
		case DISTAB_COLS:
			{
				RECT	rr;
				MoveControl(IDC_HINT_MODIFY_COLUMN, rrTab.left, rrTab.top + nGap);
				GetClientRect(GetItem(IDC_HINT_MODIFY_COLUMN), rr);

				///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				MoveControl(IDC_ADD_COLUMN_HEADING, rrTab.left, rr.bottom + nGap);
				GetClientRect(m_chkColHeader, rr);
				///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
				
				rrTab.top = rr.bottom + nGap;
				MoveControl(GetItem(IDC_DATA_INFO_ARRAGEMENT), rrTab);
			}
			break;
			
		default:
			O_A_FAIL;
			return FALSE;
		}
		
		return TRUE;
	}

	int		GetRowTabHeight(BOOL bMin)
	{
		int		nScaler = bMin ? 3 : 8;
		RECT	rr;
		GetControlClientRect(IDC_BTN_SELECT, rr);
		return RECT_HEIGHT(rr) * nScaler + 10 * GetControlGap();
	}

	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	BOOL	LoadSettings(TreeNode trSettings)
	{
		Tree trLocal;
		if ( !trSettings || !trSettings.FirstNode )
			trSettings = trLocal;
		if ( trSettings.IsEmpty() )
			GetDefaultSettings(trSettings);
		
		//load Title
		InitTitle(trSettings);
		//load Rows
		InitSelection(trSettings);
		//load Columns
		InitColumns(trSettings);
		
		//load Display
		InitDisplay(trSettings);
				
		return TRUE;
	}
	
	BOOL	SaveSettings(TreeNode& trSettings)
	{
		if ( !trSettings )
			return FALSE;

		trSettings.SetAttribute(STR_CLASS_OPTION_NAME_ATTRIB, STR_DATA_INFO_CLASS_SETTINGS);
		trSettings.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
		
		UpdateTreeFromDyna();
		
		//save Title
		SaveTitle(trSettings);
		
		//save Rows
		SaveSelection(trSettings);
		
		//save Columns
		SaveColumns(trSettings);
		
		//save Display
		SaveDisplay(trSettings);
		
		return TRUE;
	}
	
	void	InitDisplay(const TreeNode& trSettings)
	{
		m_trDisplay = tree_check_get_node(trSettings, "Display");
		if ( !m_trDisplay )
		{
			GetDisplay(TRUE);
		}
	}
	
	void	SaveDisplay(TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		
		TreeNode trDisplay = tree_check_get_node(trSettings, "Display");
		trDisplay.Replace(GetDisplay(FALSE));
		return;
	}
	
	void	InitTitle(const TreeNode& trSettings)
	{
		m_trTitle = tree_check_get_node(trSettings, "Title");
		if ( !m_trTitle )
		{
			GetTitle(TRUE);
		}
	}
	
	void	SaveTitle(TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		TreeNode trTitle = tree_check_get_node(trSettings, "Title");
		trTitle.Replace(GetTitle(FALSE));
	}

	#define		MAX_LIST_COLUMNS		20

	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	InitColumns(const TreeNode& trSettings)
	{
		if ( !trSettings )
			return;
		
		TreeNode	trColumns = trSettings.Columns;
		if ( !trColumns )
		{
			O_A_FAIL;
			return;
		}
		m_DataInfoList.ClearAll();

		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		m_chkColHeader.Check = trColumns.ColHeader.nVal;
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		
		int		nRowOffset = m_DataInfoList.GetRowOffset();
		int		nColOffset = m_DataInfoList.GetColOffset();
		for ( int ii=0; ii<trColumns.NumCols.nVal && ii<MAX_LIST_COLUMNS; ++ii )
		{
			TreeNode	trColumn = trColumns.GetNode(m_DataInfoList.GetColName(ii + 1));
			if ( !trColumn )
				break;
			
			///------ Folger 06/21/10 ORG-332 NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
			int		nInfoFrom = ConvertHeaderIndex(trColumn.InfoFrom.nVal, FALSE);
			if ( nInfoFrom < 0 )
				continue;
			///------ End NEW_DATA_INFO_SUPPORT_MATRIX_BASED_PLOT
			
			vector<string>	vs;
			int				nn = LISTROW_INFO_FROM;
			foreach ( TreeNode trNode in trColumn.Children )
			{
				vs.Add(m_DataInfoList.GetRowContentForLoading(trNode.strVal, nn++));
			}
			m_DataInfoList.AddColumn(vs);
		}
	}
	
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	IndexToName(const vector<int> vnIndices, vector<string>& vsNames)
	{
		vsNames.SetSize(0);
		int nSize = vnIndices.GetSize();
		for ( int ii = 0; ii < nSize; ii++ )
		{
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			//Column col(m_wksSrc, vnIndices[ii]);
			//if ( vnIndices[ii] == DISSRC_ROW_NUM )
			//{
				//vsNames.Add(STR_SRC_INDEX);
			//}
			//else if ( vnIndices[ii] == DISSRC_XINDEX )
			//{
				//vsNames.Add(STR_SRC_X);
			//}
			//else if ( vnIndices[ii] == DISSRC_YINDEX )
			//{
				//vsNames.Add(STR_SRC_Y);
			//}
			//else if ( vnIndices[ii] == DISSRC_ZINDEX )
			//{
				//vsNames.Add(STR_SRC_Z);
			//}
			//else if ( col.IsValid() )
			//{
				//vsNames.Add(_get_column_notation(col));
			//}
			//else
				//O_A_FAIL;
			string	strName;
			if ( IndexToName(strName, vnIndices[ii]) )
				vsNames.Add(strName);
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		}
	}

	///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
	BOOL	IndexToName(string& strName, int nIndex)
	{
		if ( nIndex == DISSRC_ROW_NUM )
		{
			strName = STR_SRC_INDEX;
		}
		else if ( nIndex == DISSRC_X )
		{
			strName = STR_DISP_X;
		}
		else if ( nIndex == DISSRC_Y )
		{
			strName = STR_DISP_Y;
		}
		else if ( nIndex == DISSRC_Z )
		{
			strName = STR_DISP_Z;
		}
		else if ( nIndex == DISSRC_XINDEX )
		{
			strName = STR_SRC_X;
		}
		else if ( nIndex == DISSRC_YINDEX )
		{
			strName = STR_SRC_Y;
		}
		else if ( nIndex == DISSRC_ZINDEX )
		{
			strName = STR_SRC_Z;
		}
		///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
		else if ( nIndex == DISSRC_SEP )
		{
			strName = STR_DISP_SEP;
		}
		///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		else
		{
			Column col(m_wksSrc, nIndex);
			if ( col )
			{
				strName = _get_column_notation(col);
			}
			else
			{
				//O_A_FAIL;
				return FALSE;
			}
		}

		return TRUE;
	}
	///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

	void	InitSelection(const TreeNode& trSettings)
	{
		if ( !trSettings.IsValid() || !trSettings.Rows )
			return;
		
		if ( !m_wksSrc.IsValid() )
		{
			DataRange drSrc;
			if ( m_DataInfoList.DataPlotPtr()->IsValid() && m_DataInfoList.DataPlotPtr()->GetDataRange(drSrc) )
			{
				int nC1, nC2;
				drSrc.GetRange(m_wksSrc, nC1, nC2);
			}
		}
		
		//TreeNode trLeft = trSettings.Rows.LeftGrid; ///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		TreeNode trRight = trSettings.Rows.RightGrid;
		vector<int> vnLeft, vnRight;
		
		///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
		//vnLeft = trLeft.nVals;
		vector<int> vnJunk;
		InitColsList(vnLeft, vnJunk);
		///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
		vnRight = trRight.nVals;
		vector<string> vsLeft, vsRight;
		IndexToName(vnLeft, vsLeft);
		IndexToName(vnRight, vsRight);
		
		m_vnMapIndex = vnLeft;
		m_vsMapName = vsLeft;
		///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		vector<int>		vn = { DISSRC_ROW_NUM
			, DISSRC_XINDEX
			, DISSRC_YINDEX
			, DISSRC_ZINDEX
			, DISSRC_X
			, DISSRC_Y
			, DISSRC_Z
			///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
			, DISSRC_SEP
			///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		};
		vector<string>	vs = { STR_SRC_INDEX
				, STR_SRC_X
				, STR_SRC_Y
				, STR_SRC_Z
				, STR_DISP_X
				, STR_DISP_Y
				, STR_DISP_Z
				///------ Folger 07/02/10 ORG-436-S4 DATA_INFO_ROW_SEPARATOR_SUPPORT
				, STR_DISP_SEP
				///------ End DATA_INFO_ROW_SEPARATOR_SUPPORT
		};
		m_vnMapIndex.Append(vn);
		m_vsMapName.Append(vs);
		///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
		
		m_DataAvailable.SetValues(vsLeft);
		m_DataSelected.SetValues(vsRight);
	}
	
	///Sophy 6/13/2010 ORG-120-P16 INIT_COLS_LIST_FROM_SRC_WORKSHEET
	void	InitColsList(vector<int>& vnList, vector<int>& vnSelected)
	{
		vnList.SetSize(0);
		vnSelected.SetSize(0);
		DataRange	dr;
		int nR1, nC1, nR2, nC2;
		if ( m_DataInfoList.DataPlotPtr()->IsValid() && m_DataInfoList.DataPlotPtr()->GetDataRange(dr) )
		{
			///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			//string strSrcX = "";
			//string strSrcY = "";
			//string strSrcZ = "";
			//Column colSrc;
			//vnList.Add(DISSRC_ROW_NUM);
			//
			//vnList.Add(DISSRC_XINDEX);
			//vnSelected.Add(DISSRC_XINDEX);
			//
			//vnList.Add(DISSRC_YINDEX);
			//vnSelected.Add(DISSRC_YINDEX);
			//if ( dr.GetRange("X", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			//{
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcX = _get_column_notation(colSrc);
				//colSrc.Detach();
			//}
			//if ( dr.GetRange("Y", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			//{
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcY = _get_column_notation(colSrc);
				//colSrc.Detach();
			//}			
			vnSelected.Add(DISSRC_X);
			vnSelected.Add(DISSRC_Y);
			///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			///------ Folger 09/21/2010 ORG-332-P1 DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
			//if ( dr.GetRange("Z", nR1, nC1, nR2, nC2, m_wksSrc) >= 0 )
			Datasheet		dsTemp;
			if ( dr.GetRange("Z", nR1, nC1, nR2, nC2, dsTemp) >= 0 )
			///------ End DATA_INFO_FAILED_TO_SHOW_Z_BY_DEFAULT_FOR_MATRIX_RELATED_PLOT
			{
				///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
				//colSrc.Attach(m_wksSrc, nC1);
				//strSrcZ = _get_column_notation(colSrc);
				//colSrc.Detach();
				//
				//vnList.Add(DISSRC_ZINDEX);
				//vnSelected.Add(DISSRC_ZINDEX);
				vnSelected.Add(DISSRC_Z);
				///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
			}

			if ( dr.GetRange(m_wksSrc, nC1, nC2) && m_wksSrc.IsValid() )
			{
				int nCols = m_wksSrc.GetNumCols();
				for (int iC = 0; iC < nCols; iC++ )
				{
					Column col(m_wksSrc, iC);
					///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
					//string strName = _get_column_notation(col);
					//if ( strName.CompareNoCase(strSrcX) == 0 
						//|| strName.CompareNoCase(strSrcY) == 0 
						//|| strName.CompareNoCase(strSrcZ) == 0 )
					//{
						//continue;
					//}
					///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
					vnList.Add(col.GetIndex());
				}
			}
		}
	}
	///end INIT_COLS_LIST_FROM_SRC_WORKSHEET
	void	NameToIndex(const vector<string>& vsName, vector<int>& vnIndex)
	{
		int nSize = vsName.GetSize();
		vnIndex.SetSize(nSize);
		for ( int ii = 0; ii < nSize; ii++ )
		{
			int iIndex = m_vsMapName.Find(vsName[ii]);
			if ( iIndex < 0 )
			{
				O_A_FAIL;
				vnIndex[ii] = DISSRC_INVALID;
				continue;
			}
			vnIndex[ii] = m_vnMapIndex[iIndex];
		}
	}
	void	SaveSelection(TreeNode& trSettings)
	{
		if ( trSettings.IsValid() )
		{
			vector<string> vsNames;
			vector<int> vnIndices;
			m_DataSelected.GetValues(vsNames);
			NameToIndex(vsNames, vnIndices);
			TreeNode trRows = tree_check_get_node(trSettings, "Rows");
			TreeNode trSelected = tree_check_get_node_by_dataid(trRows, "RightGrid", ID_DATAINFOSETTINGS_SELECTED);
			trSelected.nVals = vnIndices;
			
			m_DataAvailable.GetValues(vsNames);
			NameToIndex(vsNames, vnIndices);
			TreeNode trAvailable = tree_check_get_node_by_dataid(trRows, "LeftGrid", ID_DATAINFOSETTINGS_AVAILABLE);
			trAvailable.nVals = vnIndices;
		}
	}
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

	TreeNode	GetTitle(BOOL bFactory)
	{
		if ( bFactory )
			m_trTitle.Reset();

		if ( m_trTitle.IsEmpty() )
		{
			GETN_USE(m_trTitle)
			GETN_LIST(Title, _L("Report Title"), DISTITLE_BOOK_SHEET_INDEX, _L("None|Book Sheet and Index|Sheet Name Only|Book LongName Only|Custom")) GETN_ID(ID_DATAINFOSETTINGS_TITLE)
			GETN_OPTION_EVENT_EX(_on_report_title_change)
			GETN_STR(Format, _L("Format String"), "") GETN_ID(ID_DATAINFOSETTINGS_FORMAT)
			GETN_STR(Hint, _L("Available variables include;\r\n%N = Book Short Name\r\n%A = Book Long Name\r\n%B = Sheet name\r\nI = Row Index\r\nX, Y, Z = Data Point Coordinates\r\n\r\nExample Constructions:\r\n[%N]%B[$(I)] --> [Book1]Sheet2[321]"), "") GETN_ID(ID_DATAINFOSETTINGS_HINT)
			GETN_HINT_EX(TRUE, FALSE)
		}

		return m_trTitle;
	}

	TreeNode	GetDisplay(BOOL bFactory)
	{
		if ( bFactory )
			m_trDisplay.Reset();

		if ( m_trDisplay.IsEmpty() )
		{
			GETN_USE(m_trDisplay)
			GETN_FONT(Font, _L("Font"), 0) GETN_ID(ID_DATAINFOSETTINGS_FONT)
			GETN_COMBO(FontSize, _L("Font Size"), 10, "|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24")		GETN_OPTION_NUM_FORMAT("%d") GETN_ID(ID_DATAINFOSETTINGS_FONTSIZE)
			GETN_COLOR(FontColor, _L("Font Color"), SYSCOLOR_BLACK) GETN_ID(ID_DATAINFOSETTINGS_FONTCOLOR)
			GETN_COLOR(BkColor, _L("Background Color"), SYSCOLOR_LTGRAY) GETN_ID(ID_DATAINFOSETTINGS_BK_COLOR)
			///------ Folger 07/07/10 ORG-502-S3 SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
			GETN_COLOR(ColHeaderBkColor, _L("Column Header Background Color"), SYSCOLOR_GRAY) GETN_ID(ID_DATAINFOSETTINGS_COLHEADER_BK_COLOR)
			///------ End SUPPORT_CUSTOMIZE_COLUMN_HEADER_BACKGROUND_COLOR
			GETN_CHECK_L(FitDisplay, _L("Automatically Fit to Display"), 1) GETN_ID(ID_DATAINFOSETTINGS_FIT_DISPLAY)
			GETN_OPTION_EVENT_EX(_on_auto_fit_change)
			GETN_CHECK_L(ShowGrid, _L("Show Gridlines"), 1) GETN_ID(ID_DATAINFOSETTINGS_SHOWGRID)
		}

		return m_trDisplay;
	}
	
	void	SaveColumns(TreeNode& trSettings)
	{
		Array<vector<string>&>	arrCols(TRUE);

		int		nRowOffset = m_DataInfoList.GetRowOffset();
		int		nColOffset = m_DataInfoList.GetColOffset();
		for ( int ii=nColOffset; ii<m_DataInfoList.GetCols(); ++ii )
		{
			arrCols.Add(*(new vector<string>));
			vector<string>&		vs = arrCols.GetAt(arrCols.GetSize() - 1);

			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_INFO_FROM, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_CONTENT, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_COLUMN_WIDTH, ii));
			vs.Add(m_DataInfoList.GetRowContentForSaving(LISTROW_FONT_SIZE, ii));
		}
		TreeNode trCol = tree_check_get_node(trSettings, "Columns");
		SaveColumnsSettings(trCol, arrCols, m_chkColHeader.Check);
	}

	void	SaveColumnsSettings(TreeNode& tr, Array<vector<string>&>& arrCols, BOOL bColHeader)
	{
		///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		tr.ColHeader.nVal = bColHeader;
		tr.ColHeader.DataID = ID_DATAINFOSETTINGS_COLUMN_HEADER;
		///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
		tr.NumCols.nVal = arrCols.GetSize();
		tr.NumCols.DataID = ID_DATAINFOSETTINGS_NUM_COLUMNS;
		
		vector<string>		vsJunk(LISTROW_TOTAL-1);
		for ( int ii=0; ii<MAX_LIST_COLUMNS; ++ii )
		{
			if ( ii >= tr.NumCols.nVal && tr.GetNodeCount() == MAX_LIST_COLUMNS + 1 )
				break;

			string		strCol = m_DataInfoList.GetColName(ii + 1);
			TreeNode	trColumn = tree_check_get_node(tr, strCol);
			trColumn.SetAttribute(STR_REPEAT_ID_ATTRIB, ii + 1);
			
			vector<string>		vs;
			if ( ii < tr.NumCols.nVal )
				vs = arrCols.GetAt(ii);
			else
				vs = vsJunk;
			SaveOneColumn(trColumn, vs);
		}
	}

	void	SaveOneColumn(TreeNode& trColumn, vector<string>& vs)
	{
		trColumn.InfoFrom.strVal = vs[LISTROW_INFO_FROM-1];
		trColumn.InfoFrom.DataID = ID_DATAINFOSETTINGS_COLUMN_INFO_FROM;
		
		trColumn.Content.strVal = vs[LISTROW_CONTENT-1];
		trColumn.Content.DataID = ID_DATAINFOSETTINGS_COLUMN_CONTENT;
		
		trColumn.ColumnWidth.strVal = vs[LISTROW_COLUMN_WIDTH-1];
		trColumn.ColumnWidth.DataID = ID_DATAINFOSETTINGS_COLUMN_WIDTH;
		
		trColumn.FontSacler.strVal = vs[LISTROW_FONT_SIZE-1];
		trColumn.FontSacler.DataID = ID_DATAINFOSETTINGS_COLUMN_FONT_SIZE;
	}
	
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	void	updateButtonsOnselection()
	{
		vector<uint> vnRows;
		Button btnSelect = GetItem(IDC_BTN_SELECT);
		Button btnRemove = GetItem(IDC_BTN_REMOVE);
		btnSelect.Enable = m_DataAvailable.GetSelRows(vnRows);
		btnRemove.Enable = m_DataSelected.GetSelRows(vnRows);

		Button btnUp = GetItem(IDC_BTN_UP);
		Button btnDown = GetItem(IDC_BTN_DOWN);
		m_DataSelected.GetSelRows(vnRows);
		btnUp.Enable = vnRows.GetSize() == 1 && vnRows[0] != m_DataSelected.GetRowOffset();
		btnDown.Enable = vnRows.GetSize() == 1 && vnRows[0] != m_DataSelected.GetRows() - 1;
		return;
	}
	
	void	enableApply(bool bEnable = true)
	{
		Button btnApply = GetItem(IDC_APPLY);
		btnApply.Enable = bEnable;
	}
	
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG

	BOOL	CurrTabInReg(int& nTab, BOOL bGet)
	{
		LPCSTR		lpcszKey = "Tab";
		if ( bGet )
		{
			DWORD	dw;
			if ( !dlg_load_registry(STR_DIALOG_NAME, lpcszKey, dw, DISTAB_TITLE) )
				return FALSE;

			nTab = dw;
		}

		return dlg_save_to_registry(STR_DIALOG_NAME, lpcszKey, nTab);
	}

// 	virtual	void	ExtraInfoToThemeStr(string & str)
// 	{
// 		if ( m_DataInfoList.DataPlotPtr()->IsValid() )
// 		{
// 			string	strRange;
// 			m_DataInfoList.DataPlotPtr()->GetRangeString(strRange);
// 			if ( str.IsEmpty() )
// 				str = strRange;
// 			else
// 				str += " : " + strRange;
// 		}
// 	}

	virtual	int		ThemeGetList(TreeNode& tr, vector<string>& vsThemes, BOOL bRetZeroIfNotInThemeList = TRUE, BOOL bIncludeLastUsed = TRUE)
	{
		int		nSel = DynaDlg::ThemeGetList(tr, vsThemes, FALSE, bIncludeLastUsed);

		Tree	trJunk;
		GraphPage	gp;
		GraphLayer	gl;
		DataPlot	dp;
		GetRelatedObj(&gp, &gl, &dp);

		int		nOffset = 0;
		if ( vsThemes.GetSize() > 0 && theme_is_factory_default(vsThemes[0]) )
			++nOffset;
		if ( dp && tree_get_binary_storage(trJunk, dp, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_PLOT_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}
		if ( gl && tree_get_binary_storage(trJunk, gl, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_LAYER_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}
		if ( gp && tree_get_binary_storage(trJunk, gp, STR_DATA_INFO_SETTINGS_STORAGE_NAME) )
		{
			vsThemes.InsertAt(nOffset, STR_GRAPH_THEME);
			if ( nSel >= nOffset )
				++nSel;
		}

		if ( nSel < 0 )
		{
			int		nIndex = vsThemes.Find(m_strThemeFile);
			if (nIndex >= 0 )
				nSel = nIndex;
		}

		if ( bRetZeroIfNotInThemeList && nSel < 0 )
		{
			nSel = 0;
			tree_set_theme_file_name(tr, STR_THEME_NONE);
		}

		return nSel;
	}

	void	SaveOnApply()
	{
		BOOL	bSaveInObj = FALSE;
		SaveSettings(m_trSettings);
		if ( PDS_LAST_USED != okutil_cvt_str_to_predefined_type(m_strThemeFile) )
		{
			OriginObject	obj;
			obj = GetRelatedObj(NULL, NULL, NULL, m_strThemeFile);
			if ( obj )
			{
				SaveThemeIntoObj(m_trSettings, obj);
				bSaveInObj = TRUE;
			}
		}
		
		if ( !bSaveInObj )
			theme_update_last_used(STR_DATA_INFO_CLASS_SETTINGS, m_trSettings);
		LoadThemeFilesToCombo(m_trSettings);
		s_bLastUsedUpdatedByDlg = true; //--- CPY 6/16/10 ORG-316-P3 NO_LAST_USED_IF_NEW_INSTANCE
	}
	
	void	SaveThemeIntoObj(TreeNode& tr, OriginObject& obj)
	{
		Tree	trTheme;
		tr.SetAttribute(STR_THEME_FILE_ATTRIB, "");
		theme_save_settings(tr, NULL, false, NULL, trTheme);
		tree_put_binary_storage(trTheme, obj, STR_DATA_INFO_SETTINGS_STORAGE_NAME);
		tr.SetAttribute(STR_THEME_FILE_ATTRIB, m_strThemeFile);
	}

private:
	TreeNode						m_trSettings;
	DataInfoArrangementList			m_DataInfoList;
	///Sophy 6/9/2010 ORG-120 ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	DataRowList						m_DataAvailable;
	DataRowList						m_DataSelected;
	Worksheet						m_wksSrc;
	vector<int>						m_vnMapIndex;
	vector<string>					m_vsMapName;
	///end ROWS_TAB_FOR_NEW_DATA_INFO_SETTINGS_DLG
	string							m_strLastFile;
	TabControl						m_tab;

	int								m_nCurrTab;

	Tree							m_trTitle;
	Tree							m_trDisplay;

	string							m_strThemeFile;

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	Button							m_chkColHeader;
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
};

static bool _on_report_title_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	tr.Format.Show = tr.Hint.Show = DISTITLE_CUSTOM == trNode.nVal;
	return true;
}

static bool _on_auto_fit_change(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	tr.FontSize.SetAttribute(STR_LABEL_ATTRIB, trNode.nVal ? _L("Minimum Font Size") : _L("Font Size"));
	return true;
}

BOOL		DataInfoSettings(int nMsg, TreeNode& trSettings, OriginObject& obj, DWORD dwCntrl = 0, LPVOID lpVoid = NULL)
{
	DataPlot	dp;
	if ( obj )
	{
		dp = (DataPlot)obj;
	}

	DataInfoSettingsDlg	dlg(trSettings, dp);
	switch ( nMsg )
	{
	case DIS_MSG_OPEN_DIALOG:
		return IDOK == dlg.DoModalEx(GetWindow());
		
	case DIS_MSG_GET_DEFAUL_SETTINGS:
		return dlg.GetDefaultSettings(trSettings);

	///------ Folger 06/29/10 ORG-336 ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO
	case DIS_MSG_GET_CURSOR_VALUE:
		return dlg.GetCursorValue((CursorValue*)lpVoid);
	///------ End ADD_BACK_CURSOR_SUPPORT_FOR_DATA_INFO

	///------ Folger 07/05/10 ORG-436-S2 SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	case DIS_MSG_GET_COLUMN_HEADER:
		return dlg.GetColumnHeader((LPSTR)lpVoid, (int)dwCntrl);
	///------ End SUPPORT_COLUMN_HEADER_IN_DATA_INFO
	}
	
	return FALSE;
}
